### PreferGenericsOverRefObjectRule
This rule fires if a method has a reference argument (**ref** or **out** in C#) to System.Object. These methods can generally be rewritten in .NET 2.0 using generics which provides type safety, eliminates casts, and makes the API easier to consume.

**Bad** example:

``` csharp
// common before 2.0 but we can do better now
public bool TryGetValue (string key, ref object value)
{
    // ...
}
```
**Good** example:

``` csharp
public bool TryGetValue<T> (string key, ref T value)
{
    // ...
}
```
**Notes**

-   This rule is available since Gendarme 2.2
