### ReplaceIncompleteOddnessCheckRule
This rule checks for problematic oddness checks. Often this is done by comparing a value modulo two (% 2) with one (1). However this will not work if the value is negative because negative one will be returned. A better (and faster) approach is to check the least significant bit of the integer.

**Bad** example:

``` csharp
public bool IsOdd (int x)
{
    // (x % 2) won't work for negative numbers (it returns -1)
    return ((x % 2) == 1);
}
```
**Good** example:

``` csharp
public bool IsOdd (int x)
{
    return ((x % 2) != 0);
}
```
**Good** example (faster):

``` csharp
public bool IsOdd (int x)
{
    return ((x & 1) == 1);
}
```
**Notes**

-   This rule is available since Gendarme 2.0
