### UseCorrectSignatureForSerializationMethodsRule
This rule checks for methods which use the serialization attributes: **[OnSerializing, OnDeserializing, OnSerialized, OnDeserialized]**. You must ensure that these methods have the correct signature. They should be **private**, return **void** and have a single parameter of type **StreamingContext**. Failure to have the right signature can, in some circumstances, make your assembly unusable at runtime.

**Bad** example:

``` csharp
[Serializable]
public class Bad {
    [OnSerializing]
    public bool Serializing (StreamingContext context)
    {
    }
}
```
**Good** example:

``` csharp
[Serializable]
public class BadClass {
    [OnSerializing]
    private void Serializing (StreamingContext context)
    {
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0

Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
