### UseSTAThreadAttributeOnSWFEntryPointsRule
This rule checks executable assemblies, i.e. \*.exe's, that reference System.Windows.Forms to ensure that their entry point is decorated with **[System.STAThread]** attribute and is not decorated with **[System.MTAThread]** attribute to ensure that Windows Forms work properly.

**Bad** example #1 (no attributes):

``` csharp
public class WindowsFormsEntryPoint {
    static void Main ()
    {
    }
}
```
**Bad** example #2 (MTAThread)

``` csharp
public class WindowsFormsEntryPoint {
    [MTAThread]
    static void Main ()
    {
    }
}
```
**Good** example #1 (STAThread):

``` csharp
public class WindowsFormsEntryPoint {
    [STAThread]
    static void Main ()
    {
    }
}
```
**Good** example #2 (not Windows Forms):

``` csharp
public class ConsoleAppEntryPoint {
    static void Main ()
    {
    }
}
```
Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
