### UseSingularNameInEnumsUnlessAreFlagsRule
The rule is used for ensure that the name of enumerations are in singular form unless the enumeration is used as flags, i.e. decorated with the **[Flags]** attribute.

**Bad** example:

``` csharp
public enum MyCustomValues {
    Foo,
    Bar
}
```
**Good** example (singular):

``` csharp
public enum MyCustomValue {
    Foo,
    Bar
}
```
**Good** example (flags):

``` csharp
[Flags]
public enum MyCustomValues {
    Foo,
    Bar,
    AllValues = Foo | Bar
}
```
Feedback
========
Please report any documentation errors, typos or suggestions to the [Gendarme Google Group](http://groups.google.com/group/gendarme). Thanks!
