## Use the `--no-cache` switch

### Problematic code:

```dockerfile
FROM alpine:3.7
RUN apk update \
    && apk add foo=1.0 \
    && rm -rf /var/cache/apk/*
```

```dockerfile
FROM alpine:3.7
RUN apk add --update foo=1.0
    && rm -rf /var/cache/apk/*
```

### Correct code:

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo=1.0
```
### Rationale:

As of Alpine Linux 3.3 there exists a new `--no-cache` option for `apk`. It allows users to install packages with an index that is updated and used on-the-fly and not cached locally:

This avoids the need to use `--update` and remove `/var/cache/apk/*` when done installing packages.

> inspired by https://github.com/gliderlabs/docker-alpine/blob/master/docs/usage.md#disabling-cache