package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_PlayUntrustedContentTypeHeader extends Pattern {

  private[this] lazy val headerName = "Content-Type"

  override def apply(tree: Tree) = {
    if(hasPlayHint(tree)){
      tree.collect{
        case t@q"$_.headers(${p:Lit})" if isHeaderParam(p,t) =>
          Result(message(t),t)
        case t@q"$_.headers.apply(${p:Lit})" if isHeaderParam(p,t) =>
          Result(message(t),t)
        case t@q"$_.headers.get(${p:Lit})" if isHeaderParam(p,t) =>
          Result(message(t),t)
        case t@q"$_.headers.getAll(${p:Lit})" if isHeaderParam(p,t) =>
          Result(message(t),t)
      }
    }
    else Seq.empty
  }

  private[this] def isHeaderParam(param:Lit, tree:Tree):Boolean = {
    param.value == headerName && isInActionExpr(tree)
  }

  //are we on the rhs of a Handler(Action)?
  private[this] def isInActionExpr(tree:Tree):Boolean = {
    (tree,tree.parent) match{
      case (_:Defn.Def,_) =>
        false
      case (q"Action(..$aexprssnel)",_) =>
        true
      case (q"Action.async",_) =>
        true
      case (_,Some(parent)) =>
        isInActionExpr(parent)
      case _ =>
        false
    }
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasPlayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"play.api.mvc.{..$importeesnel}" => true
    }.exists(identity)
  }

  private[this] def message(tree:Tree) = Message(s"Depending on the ${headerName} header is considered insecure")
}