package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_PredictableRandom extends Pattern {

  override def apply(tree: Tree) = {

    tree.collect{
      //constructions
      case t@q"new { ..$stat } with ..$inits { $self => ..$_ }" =>
        lazy val hasImport = t.parent.exists(hasEvilImport(_,t.pos))
        inits.find(isRandomCtor(_,hasImport = hasImport))

      //calls
      case t@q"${term:Term}.${call:Name}(..$_)" if call.value != "javaRandomToRandom" && isRandomApply(term,hasImport = t.parent.exists( hasEvilImport(_,t.pos)) ) =>
        Option(t)

      //calls to javaRandomToRandom with insecure random
      case t@q"$_.javaRandomToRandom(${param: Term})" =>
        lazy val hasImport = t.parent.exists(hasEvilImport(_,t.pos))
        Option(param).find(isRandomCtor(_,hasImport = hasImport))

      //inits
      case t@init"$tpe(...$exprss)" =>
        lazy val constructions = tree.collect { case q"new { ..$stat } with ..$inits { $self => ..$_ }" => inits }
        lazy val hasImport = t.parent.exists(hasEvilImport(_,t.pos))
        Option(t).filterNot(tf => constructions.exists(_ == tf)).find(isRandomCtor(_,hasImport = hasImport))

    }.collect{ case Some(tree) => Result(message,tree) }
  }

  private[this] def hasEvilImport(tree:Tree,pos:Position):Boolean = {

    val foundInThisScope = tree.collect{
      case t@importer"$select.{..${importeesnel:Seq[Importee]} }" if t.pos.isBefore(pos) && isUtilSelector(select) =>
        importeesnel
    }.flatten.exists{
      case importee"_" => true

      case importee"${name:Name}" => isRandomName(name)

      case _ => false
    }

    foundInThisScope || tree.parent.exists(hasEvilImport(_,pos))
  }

  private[this] def isRandomName(name:Tree) = {
    name.toString == "Random"
  }

  private[this] def isRandomApply(term:Term, hasImport: => Boolean):Boolean = {
    term match{
      case q"${name:Name}" =>
        isRandomName(name) && hasImport
      case q"$sel.$rnd" =>
        isUtilSelector(sel) && isRandomApply(rnd,hasImport = true)
      case _ =>
        false
    }
  }

  private[this] def isRandomCtor(t:Tree, hasImport: => Boolean):Boolean = {
    t match {
      case q"$expr(...$exprss)" if exprss.flatten.isEmpty =>
        hasImport && isRandomName(expr)
      case t"$sel.$rnd" =>
        isUtilSelector(sel) && isRandomName(rnd)
      case init"$tpe(...$exprss)" if exprss.flatten.isEmpty =>
        (hasImport && isRandomName(tpe)) || isRandomCtor(tpe, hasImport)
      case _ => false
    }
  }

  private[this] def isUtilSelector(t:Term) = t match{
    case q"java.util"  => true
    case q"scala.util" => true
    case q"util"       => true
    case _             => false
  }

  private def message = Message("Don't use a predictable random number generator")
}
