package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_ReDosDetector extends Pattern{

  override def apply(tree: Tree) = {
    tree.collect{
      case q"${lit: Lit}.r" if isEvilRegex(lit) =>
        Result(message(lit),lit)
    }
  }

  private[this] def isEvilRegex(lit:Lit):Boolean = {
    lit.value match{
      case regex:String =>
        numPlusesAfterCloses(regex) >= 2
      case _ => false
    }
  }

  private[this] val CLOSING_CHAR = Set(')', ']')
  private[this] val PLUS_CHAR = Set('+', '*', '?')

  private implicit class cExt(val char:Char) extends AnyVal{
    def isEscape = char == '\\'
    def isClosing = CLOSING_CHAR.contains(char)
    def isPlus = PLUS_CHAR.contains(char)
  }

  //count closing followed by plus chars
  private[this] def numPlusesAfterCloses(regex:String) = {
    val (count, _, _) = regex.foldLeft( (0,false,false) ){ case ((count,escaping,justClosed),char) =>
      char match{
        case char if escaping =>
          (count,false,false)

        case c if c.isClosing =>
          (count,false,true)

        case c if c.isPlus && justClosed =>
          (count + 1, false, false)

        case _ =>
          (count, char.isEscape, false)
      }
    }

    count
  }

  private[this] def message(regex: Lit) = Message(s"Possible problematic Regex found: '${regex}'")
}