package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SprayRequestHeaders extends Pattern{

  override def apply(tree: Tree) = {
    if(hasSprayHint(tree)){
      tree.collect{
        case t@q"""headerValue($expr)""" =>
          Result(message(t),t)
        case t@q"""optionalHeaderValue($expr)""" =>
          Result(message(t),t)
        case t@q"""headerValueByName($expr)""" =>
          Result(message(t),t)
        case t@q"""optionalHeaderValueByName($expr)""" =>
          Result(message(t),t)
        case t@q"headerValueByType[$tpe]" =>
          Result(message(t),t)
        case t@q"optionalHeaderValueByType[$tpe]" =>
          Result(message(t),t)
        case t@q"headerValuePF($expr)" =>
          Result(message(t),t)
        case t@q"optionalHeaderValuePF($expr)" =>
          Result(message(t),t)
      }
    }
    else Seq.empty
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def message(tree:Tree) = Message("Depending on request headers is considered insecure")
}
