package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SprayUntrustedContentTypeHeader extends Pattern {

  //we see a lot of backticks in spray headers
  private[this] lazy val headerName = "Content-Type"

  private[this] lazy val HeaderTypeNames = Set(headerName,s"`$headerName`")

  override def apply(tree: Tree) = {
    lazy val importsHeader = importsSprayHostHeader(tree)
    if(hasSprayHint(tree)){
      tree.collect{
        case t@q"""headerValueByName(${lit: Lit})""" if lit.value == headerName =>
          Result(message,t)
        case t@q"""optionalHeaderValueByName(${lit: Lit})""" if lit.value == headerName =>
          Result(message,t)
        case t@q"headerValueByType[$tpe]" if isHostHeaderType(tpe,importsHeader) =>
          Result(message,t)
        case t@q"optionalHeaderValueByType[$tpe]" if isHostHeaderType(tpe,importsHeader) =>
          Result(message,t)
        case p"case ${pat:Pat} if $expropt => $expr" if hasHostType(pat) =>
          Result(message,pat)
      }
    }
    else Seq.empty
  }

  private[this] def isHostHeaderType(tree:Type, importsHeader: => Boolean):Boolean = {
    Option(tree).exists{
      case t"${sel:Term.Name}.${tpe:Type.Name}" =>
        sel.toString == "HttpHeaders" && HeaderTypeNames.contains(tpe.toString)
      case t"${name: Type.Name}" =>
        HeaderTypeNames.contains(name.toString) && importsHeader
      case _ => false
    }
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def hasHostType(pat:Pat):Boolean = {
    pat.collect{
      case q"${name: Term.Name}" =>
        HeaderTypeNames.exists(_ == name.toString)
      case q"${name: Type.Name}" =>
        HeaderTypeNames.exists(_ == name.toString)
    }.exists(identity)
  }

  private[this] def importsSprayHostHeader(tree:Tree):Boolean = {
    tree.collect{
      case t@importer"$ref.{..${importeesnel:Seq[Importee]}}" =>
        Option(ref).exists{
          case q"spray.http.HttpHeaders" => true
          case _ => false
        } && importeesnel.exists{
          case importee"${iname:Name}" =>
            HeaderTypeNames.exists(_ == iname.toString)
          case importee"_" => true
          case _ => false
        }
    }.exists(identity)
  }

  private[this] def message = Message("Untrusted Hostname header")
}
