package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_SprayUntrustedHttpRequestParameter extends Pattern {

  override def apply(tree: Tree) = {
    if(hasSprayHint(tree)){
      tree.collect{
        case t@q"""parameter(..$expr)""" =>
          Result(message, t)
        case t@q"""parameters(..$expr)""" =>
          Result(message, t)
        case t@q"""parameterSeq(..$expr)""" =>
          Result(message, t)
        case t@q"""parameterMap(..$expr)""" =>
          Result(message, t)
        case t@q"""parameterMultiMap(..$expr)""" =>
          Result(message, t)
      }
    }
    else Seq.empty
  }

  //this is merely to avoid false positives remove it if the pattern never encounters issues
  private[this] def hasSprayHint(tree:Tree):Boolean = {
    tree.collect{
      case importer"spray.http._" => true
    }.exists(identity)
  }

  private[this] def message = Message("The method takes a value that is controlled by the client")
}
