package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_WeakDigest extends Pattern {

  override def apply(tree: Tree) = {
    tree.collect {
      case t@q"MessageDigest.getInstance( ..${args: Seq[Term]} )" if isOffender(args) =>
        Result(message, t)
      case t@q"java.security.MessageDigest.getInstance( ..${args: Seq[Term]} )" if isOffender(args) =>
        Result(message,t)
    }
  }

  private val allowed = Set("SHA-256", "SHA-384", "SHA-512")

  private def isOffender(args: Seq[Term]): Boolean = {
    val algorithmOpt = args.headOption.flatMap {
      case q"${expr: Lit}" =>
        litToString(expr)
      case _ =>
        None
    }
    algorithmOpt.exists(algorithm => !allowed.contains(algorithm))
  }

  private def litToString(lit: Lit): Option[String] = {
    lit.value match {
      case str: String => Option(str)
      case _ => None
    }
  }

  private def message = Message("Message digest is weak")
}
