package codacy.patterns

import codacy.base.Pattern

import scala.meta._

case object Custom_Scala_XEEVulnerability extends Pattern{

  override def apply(tree: Tree): List[Result] = {
    tree.collect{
      case t@q"SAXParserFactory.newInstance().newSAXParser()" => Result(message(t),t)
      case t@q"javax.xml.parsers.SAXParserFactory.newInstance().newSAXParser()" => Result(message(t),t)
    }
  }

  private[this] def message(tree: Tree) = Message("XML parser vulnerable to XXE attacks")
}
