## This shebang was unrecognized. ShellCheck only supports sh/bash/dash/ksh. Add a 'shell' directive to specify.

### Problematic code:

```sh
#!/bin/mywrapper
echo "Hello World"
```

### Correct code:

```sh
#!/bin/mywrapper
# shellcheck shell=bash
echo "Hello World"
```

### Rationale:

You have specified a shebang that ShellCheck doesn't recognize. This can be due to invoking the script via a wrapper, specifying a dummy like `#!/bin/false` to prevent execution, or trying to check a script for a non-Bourne shell or tool.

If this really is a sh/bash/dash/ksh script, please add a `shell` directive after the shebang to tell ShellCheck how to interpret the script, as in the example. You can also specify the shell with the `-s` flag. 

If this is a script in some other language, like `#!/bin/sed` for a `sed` script, then sorry -- ShellCheck does not support `sed`, `awk`, `expect` scripts. It only supports Bourne style shell scripts. 

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1008)

