## Couldn't find 'done' for this 'do'.

### Problematic code:

```sh
yes() {
  while echo "y"
  do
    true
}
```

### Correct code:

```sh
yes() {
  while echo "y"
  do
    true
  done
}
```
### Rationale:

ShellCheck found a `do` without a corresponding `done`.

Double check that the `done` exists, and that it correctly matches the indicated `do`. A companion warning [[SC1062]] is emitted where ShellCheck first noticed it was missing. 

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1061)

