## This is an unquoted HTML entity. Replace with corresponding character.

### Problematic code:

```sh
foo &amp;&amp; bar
```

### Correct code:

```sh
foo && bar
```

### Rationale:

There is an unquoted HTML entity, such as `&amp;`, `&gt;` or `&lt;` (instead of `&`, `>` and `<`) in your code. This usually happens when copy-pasting from a web site that has mismanaged its code formatting.

You should go through the entire script and replace HTML entities with their corresponding characters. 

Don't rely on ShellCheck to detect all of them. ShellCheck only warns about certain cases in certain contexts, while this issue tends to affect the entire script.

### Exceptions:

If you want to run a command called `amp` after backgrounding another command, add a space: `foo & amp;`.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1109)

