## Unexpected start of line. If breaking lines, |/||/&& should be at the end of the previous one.

### Problematic code:

```sh
dmesg
  | grep "error"
```

### Correct code:

```sh
dmesg |
  grep "error"
```

### Rationale:

ShellCheck has found a line that unexpectedly started with `|`, `||` or `&&`. This usually happens when a line is broken incorrectly.

When breaking around a `|`, `||` or `&&`, there are two options:

* Break the line *after* this token. `dmesg` is a complete command by itself, but `dmesg |` is not so the shell knows to continue on the next line.
* Use a `\` at the end of the previous line to explicitly tell the shell to continue on the next.

### Exceptions:

None. This is a syntax error.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1133)

