## This word is outside of quotes. Did you intend to `'nest '"'single quotes'"'` instead'?

### Problematic code:

```sh
alias server_uptime='ssh $host 'uptime -p''
```

### Correct code:

```sh
alias server_uptime='ssh $host '"'uptime -p'"
```

### Rationale:

In the first case, the user has four single quotes on a line, wishfully hoping that the shell will match them up as outer quotes around a string with literal single quotes:

```sh
#                   v--------match--------v
alias server_uptime='ssh $host 'uptime -p''
#                              ^--match--^
```

The shell, meanwhile, always terminates single quoted strings at the first possible single quote:

```sh
#                   v---match--v
alias server_uptime='ssh $host 'uptime -p''
#                                        ^^
```

Which is the same thing as `alias server_uptime='ssh $host uptime' -p`.

There is no way to nest single quotes. However, single quotes can be placed literally in double quotes, so we can instead concatenate a single quoted string and a double quoted string:

```sh
#                   v--match---v
alias server_uptime='ssh $host '"'uptime -p'"
#                               ^---match---^
```

This results in an alias with embedded single quotes.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2026)

