## Quote the rhs of = in [[ ]] to prevent glob matching.

### Problematic code:

```sh
[[ $a = $b ]]
```

### Correct code:

```sh
[[ $a = "$b" ]]
```
### Rationale:

When the right-hand side of `=`, `==` or `!=` is unquoted in `[[ .. ]]`, it will be treated like a glob.

This has some unexpected consequences like `[[ $var = $var ]]` being false (for `var='[a]'`), or `[[ $foo = $bar ]]` giving a different result from `[[ $bar = $foo ]]`.

The most common intention is to compare one variable to another as strings, in which case the right-hand side must be quoted.

### Exceptions:

If you explicitly want to match against a pattern, you can [[ignore]] this warning.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2053)

