## You probably wanted && here

### Problematic code:

```sh
if  (( $1 != 0 || $1 != 3 ))
then
  echo "$1 is not 0 or 3"
fi
```

### Correct code:

```sh
if  (( $1 != 0 && $1 != 3 ))
then
  echo "$1 is not 0 or 3"
fi
```

### Rationale:

This is not a bash issue, but a simple, common logical mistake applicable to all languages.

`(( $1 != 0 || $1 != 3 ))` is always true:

* If `$1 = 0` then `$1 != 3` is true, so the statement is true.
* If `$1 = 3` then `$1 != 0` is true, so the statement is true.
* If `$1 = 42` then `$1 != 0` is true, so the statement is true.

`(( $1 != 0 && $1 != 3 ))` is true only when `$1` is not `0` and not `3`:

* If `$1 = 0`, then `$1 != 3` is false, so the statement is false.
* If `$1 = 3`, then `$1 != 0` is false, so the statement is false.
* If `$1 = 42`, then both `$1 != 0` and `$1  != 3` is true, so the statement is true.

This statement is identical to `! (( $1 == 0 || $1 == 3 ))`, which also works correctly.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2056)

