## This assignment is only seen by the forked process.

### Problematic code:

```sh
name=World cmd -m "Hello $name"
```

### Correct code:

```sh
export name=World
cmd -m "Hello $name"
```

To prevent setting the variable, this can also be done in a subshell:

```sh
(
   export name=World
   cmd -m "Hello $name"
) # 'name' does not leave this subshell
```

### Rationale:

In `name=World cmd "$name"`, `name=World` is passed in as part of the environment to `cmd` (i.e., in the `envp` parameter to [execve(2)](http://linux.die.net/man/2/execve)).  This means that `cmd` and its children will see the parameter, but no other processes will.

However, `"$name"` is not expanded by `cmd`. `"$name"` is expanded by the shell before `cmd` is ever executed, and thus it will not use the new value.

The solution is to set the variable and export the variable first. If limited scope is desired, a `( subshell )` can be used.

### Exceptions

In the strange and fabricated scenarios where the script and a program uses a variable name for two different purposes, you can ignore this message. This is hard to conceive, since scripts should use lowercase variable names specifically to avoid collisions with the environment.

### Related resources:

* [BashFaq: Why doesn't foo=bar echo "$foo" print bar?](https://mywiki.wooledge.org/BashFAQ/104)
* [StackOverflow: Prefixing variable assignment doesn't work with echo](https://stackoverflow.com/questions/36380569/prefixing-variable-assignment-doesnt-work-with-echo?rq=1)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2097)

