## >= is not a valid operator. Use '! a < b' instead.

### Problematic code:

```sh
[[ a &lt;= b ]]
```

### Correct code:

```sh
[[ ! a > b ]]
```

### Rationale:

The operators `<=` and `>=` are not supported by Bourne shells. Instead of "less than or equal", rewrite as "not greater than".

### Exceptions

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2122)

