##  Tips depend on target shell and yours is unknown. Add a shebang.

### Problematic code:

```sh
echo "$RANDOM"   # Does this work?
```

### Correct code:

```sh
#!/bin/sh
echo "$RANDOM"  # Unsupported in sh. Produces warning.
```

or

```sh
#!/bin/bash
echo "$RANDOM"  # Supported in bash. No warnings.
```

### Rationale:

Different shells support different features. To give effective advice, ShellCheck needs to know which shell your script is going to run on. You will get a different numbers of warnings about different things depending on your target shell.

If you add a shebang (e.g. `#!/bin/bash` as the first line), the OS will use this interpreter when the script is executed, and ShellCheck will use this shell when offering advice.

If you for any reason can't or won't add a shebang, there are multiple other ways to let shellcheck know which shell you're coding for:

* Specify the shell using the `-s` or `--shell` flag, e.g. `shellcheck -s bash myfile`
* Use a shellcheck [[directive]], adding `# shellcheck shell=ksh` before the first command in the file.
* Give the script a `.bash`, `.ksh` or `.dash` extension (`.sh` will not assume `--shell=sh` since it's so generic)

Note that this error can not be ignored with a [[directive]]. It is not a suggestion to improve your script, but a warning that ShellCheck lacks information it needs to be helpful.

### Exceptions

None. Please either add a shebang, directive, extension or use `-s`.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2148)

