## You can't have | between this redirection and the command it should apply to.

### Problematic code:

```sh
< file.txt | grep foo
```

### Correct code:

```sh
< file.txt grep foo   # or more canonically: grep foo < file.txt
```

### Rationale:

ShellCheck has found a stage in a pipeline that consists of a redirection but no command. This doesn't make sense because a redirection without a command will not read or write any data.

This is most likely to occur when deleting a command that had a redirection, but leaving a `|` behind instead of moving the redirection to a different command:

```
# Match lines with line numbers
nl < foo.txt | grep bar

# Incorrect attempt at removing line numbers. grep now has no input:
< foo.txt | grep bar

# Line numbers correctly removed. grep now reads foo.txt as intended.
grep bar < foo.txt
```

### Exceptions:

It's technically valid to do e.g. `echo foo | > "$(cat)"` to truncate a file called "foo", but please consider rewriting such code.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2189)

