##  fgrep is non-standard and deprecated. Use grep -F instead.

### Problematic code:

```sh
fgrep '*.*' file
```

### Correct code:

```sh
grep -F '*.*' file
```
### Rationale:

`fgrep` is a non-standard command. Its functionality is provided in POSIX by `grep -F`. [POSIX grep](http://pubs.opengroup.org/onlinepubs/9699919799/utilities/grep.html) says:

>This grep has been enhanced in an upwards-compatible way to provide the exact functionality of the historical egrep and fgrep commands as well. It was the clear intention of the standard developers to consolidate the three greps into a single command.

man grep for GNU says:

>Direct invocation as either egrep or fgrep is deprecated

### Exceptions:

ShellCheck will fail to recognize when functions override `fgrep`. Consider giving it a different name or [[ignore]] this error. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2197)

