## Globs are ignored in `[[ ]]` except right of =/!=. Use a loop.

### Problematic code:

```sh
[[ current.log -nt backup/*.log ]] && echo "This is the latest file"

```

### Correct code:

```sh
newerThanAll=true
for log in backup/*.log
do
  [[ current.log -nt "$log" ]] || newerThanAll=false
done
[[ "$newerThanAll" = "true" ]] && echo "This is the latest file"
```

### Rationale:

Globs in `[[ ]]` will not filename expand, and will be treated literally (or as patterns on the right-hand side of `=`, `==` and `!=`).

The problematic code is equivalent to `[[ current.log -nt 'backup/*.png' ]`, and will look for a file with a literal asterisk in the name.

Instead, you can iterate over the filenames you want with a loop, and apply your condition to each filename.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2203)

