
A magic number is a number that comes out of nowhere, and is directly used in a statement. Magic numbers are often used, for instance to limit the<br>number of iterations of a loops, to test the value of a property, etc.

Using magic numbers may seem obvious and straightforward when you're writing a piece of code, but they are much less obvious and straightforward at<br>debugging time.

That is why magic numbers must be demystified by first being assigned to clearly named variables before being used.

-1, 0 and 1 are not considered magic numbers.

## Noncompliant Code Example


    public static void DoSomething()
    {
        for(int i = 0; i &lt; 4; i++)  // Noncompliant, 4 is a magic number
        {
            ...
        }
    }


## Compliant Solution


    private const int NUMBER_OF_CYCLES = 4;
    
    public static void DoSomething()
    {
        for(int i = 0; i &lt; NUMBER_OF_CYCLES ; i++)  //Compliant
        {
            ...
        }
    }


## Exceptions

This rule doesn't raise an issue when the magic number is used as part of the `GetHashCode` method or a variable/field declaration.
