
While not technically incorrect, the omission of curly braces can be misleading, and may lead to the introduction of errors during maintenance.

## Noncompliant Code Example


    // the two statements seems to be attached to the if statement, but that is only true for the first one:
    if (condition)
      ExecuteSomething();
      CheckSomething();


## Compliant Solution


    if (condition)
    {
      ExecuteSomething();
      CheckSomething();
    }


## See

- [CERT, EXP19-C.](https://www.securecoding.cert.org/confluence/x/1QGMAg) - Use braces for the body of an if, for, or while statement<br>
- [CERT, EXP52-J.](https://www.securecoding.cert.org/confluence/x/3wHEAw) - Use braces for the body of an if, for, or while statement<br>

