
Calling `GC.Collect` is rarely necessary, and can significantly affect application performance. That's because it triggers a blocking<br>operation that examines *every object in memory* for cleanup. Further, you don't have control over when this blocking cleanup will actually<br>run.

As a general rule, the consequences of calling this method far outweigh the benefits unless perhaps you've just triggered some event that is unique<br>in the run of your program that caused a lot of long-lived objects to die.

This rule raises an issue when `GC.Collect` is invoked.

## Noncompliant Code Example


    static void Main(string[] args)
    {
      // ...
      GC.Collect(2, GCCollectionMode.Optimized); // Noncompliant
    }

