
Hardcoding IP addresses is security-sensitive. It has led in the past to the following vulnerabilities:

- [CVE-2006-5901](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5901)
- [CVE-2005-3725](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2005-3725)


Today's services have an ever-changing architecture due to their scaling and redundancy needs. It is a mistake to think that a service will always<br>have the same IP address. When it does change, the hardcoded IP will have to be modified too. This will have an impact on the product development,<br>delivery and deployment:

- The developers will have to do a rapid fix every time this happens, instead of having an operation team change a configuration file.
- It forces the same address to be used in every environment (dev, sys, qa, prod).


Last but not least it has an effect on application security. Attackers might be able to decompile the code and thereby discover a potentially<br>sensitive address. They can perform a Denial of Service attack on the service at this address or spoof the IP address. Such an attack is always<br>possible, but in the case of a hardcoded IP address the fix will be much slower, which will increase an attack's impact.

## Recommended Secure Coding Practices

- make the IP address configurable.


## Noncompliant Code Example


    var ip = "192.168.12.42";
    var address = IPAddress.Parse(ip);


## Compliant Solution


    var ip = ConfigurationManager.AppSettings["myapplication.ip"];
    var address = IPAddress.Parse(ip);


## Exceptions

- Although "::" is a valid IPv6 address, the rule doesn't report on it.
- No issue is reported for 127.0.0.1 because loopback is not considered as sensitive


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [CERT, MSC03-J.](https://www.securecoding.cert.org/confluence/x/qQCHAQ) - Never hard code sensitive information

