
When a test fails due, for example, to infrastructure issues, you might want to ignore it temporarily. But without some kind of notation about why<br>the test is being ignored, it may never be reactivated. Such tests are difficult to address without comprehensive knowledge of the project, and end up<br>polluting their projects.

This rule raises an issue for each ignored test that does not have a `WorkItem` attribute nor a comment about why it is being skipped on<br>the right side of the `Ignore` attribute.

## Noncompliant Code Example


    [TestMethod]
    [Ignore]  // Noncompliant
    public void Test_DoTheThing()
    {
      // ...
    }


## Compliant Solution


    [TestMethod]
    [Ignore]  // renable when TCKT-1234 is fixed
    public void Test_DoTheThing()
    {
      // ...
    }


or


    [TestMethod]
    [Ignore]
    [WorkItem(1234)]
    public void Test_DoTheThing()
    {
      // ...
    }


## Exceptions

The rule doesn't raise an issue if:

- the test method is also marked with `WorkItem` attribute

- there is a comment on the right side of the `Ignore` attribute
