
Inappropriate casts are issues that will lead to unexpected behavior or runtime errors, such as `InvalidCastException`s. The compiler<br>will catch bad casts from one class to another, but not bad casts to interfaces. Nor will it catch nullable values that are known to be null but that<br>are cast to their underlying value types anyway.

It is much better to use the `as` operator because it will return `null` instead of throwing an exception.

## Noncompliant Code Example


    public interface IMyInterface
    { /* ... */ }
    
    public class Implementer : IMyInterface
    { /* ... */ }
    
    public class MyClass
    { /* ... */ }
    
    public static class Program
    {
      public static void Main()
      {
        var myclass = new MyClass();
        var x = (IMyInterface) myclass; // Noncompliant, InvalidCastException is being thrown
        var b = myclass is IMyInterface; // Noncompliant, always false
    
        int? i = null;
        var ii = (int)i; // Noncompliant, InvalidOperationException is being thrown
      }
    }


## Compliant Solution


    public interface IMyInterface
    { /* ... */ }
    
    public class Implementer : IMyInterface
    { /* ... */ }
    
    public class MyClass
    { /* ... */ }
    
    public static class Program
    {
      public static void Main()
      {
        var myclass = new MyClass();
        var x = myclass as IMyInterface; // Compliant, but will always be null
        var b = false;
    
        int? i = null;
        if (i.HasValue)
        {
          var ii = (int)i;
        }
      }
    }


## Exceptions

No issue is reported if the interface has no implementing class in the assembly.

## See

- [CERT, EXP36-C.](https://www.securecoding.cert.org/confluence/x/tgAV) - Do not cast pointers into more strictly aligned pointer<br>  types
- [MITRE, CWE-588](http://cwe.mitre.org/data/definitions/588.html) - Attempt to Access Child of a Non-structure Pointer
- [MITRE, CWE-704](http://cwe.mitre.org/data/definitions/704.html) - Incorrect Type Conversion or Cast

