
The "secure" attribute prevents cookies from being sent over plaintext connections such as HTTP, where they would be easily eavesdropped upon.<br>Instead, cookies with the secure attribute are only sent over encrypted HTTPS connections.

## Recommended Secure Coding Practices

- set the field `Secure` to `true` on the `HttpCookie` object


## Noncompliant Code Example


    HttpCookie myCookie = new HttpCookie("UserSettings");
    myCookie.Secure = false; // Noncompliant; explicitly set to false
    ...
    Response.Cookies.Add(myCookie);



    HttpCookie myCookie = new HttpCookie("UserSettings"); // Noncompliant; the default value of 'Secure' is used (=false)
    ...
    Response.Cookies.Add(myCookie);


## Compliant Solution


    HttpCookie myCookie = new HttpCookie("UserSettings");
    myCookie.Secure = true; // Compliant
    ...
    Response.Cookies.Add(myCookie);


## See

- [OWASP Top 10 2017 Category A2](https://www.owasp.org/index.php/Top_10-2017_A2-Broken_Authentication) - Broken Authentication
- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [MITRE, CWE-311](http://cwe.mitre.org/data/definitions/311) - Missing Encryption of Sensitive Data
- [MITRE, CWE-315](http://cwe.mitre.org/data/definitions/315) - Cleartext Storage of Sensitive Information in a Cookie
- [MITRE, CWE-614](http://cwe.mitre.org/data/definitions/614) - Sensitive Cookie in HTTPS Session Without 'Secure' Attribute
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

