
Because parameter names could be changed during refactoring, they should not be spelled out literally in strings. Instead, use<br>`nameof()`, and the string that's output will always be correct.

This rule raises an issue when any string in the `throw` statement is an exact match for the name of one of the method parameters.

## Noncompliant Code Example


    void DoSomething(int someParameter)
    {
        if (someParameter &lt; 0)
        {
            throw new ArgumentException("Bad argument", "someParameter");  // Noncompliant
        }
    }


## Compliant Solution


    void DoSomething(int someParameter)
    {
        if (someParameter &lt; 0)
        {
            throw new ArgumentException("Bad argument", nameof(someParameter));
        }
    }


## Exceptions

The rule doesn't raise any issue when using C# &lt; 6.0.
