
When a non-`static` class field is annotated with `ThreadStatic`, the code seems to show that the field can have different<br>values for different calling threads, but that's not the case, since the `ThreadStatic` attribute is simply ignored on<br>non-`static` fields.

So `ThreadStatic` should either be removed or replaced with a use of the `ThreadLocal<T>` class, which gives a similar<br>behavior for non-`static` fields.

## Noncompliant Code Example


    public class MyClass
    {
      [ThreadStatic]  // Noncompliant
      private int count = 0;
    
      // ...
    }


## Compliant Solution


    public class MyClass
    {
      private int count = 0;
    
      // ...
    }


or


    public class MyClass
    {
      private readonly ThreadLocal&lt;int&gt; count = new ThreadLocal&lt;int&gt;();
      public int Count
      {
        get { return count.Value; }
        set { count.Value = value; }
      }
      // ...
    }

