
`GC.SuppressFinalize` asks the Common Language Runtime not to call the finalizer of an object. This is useful when implementing the<br>dispose pattern where object finalization is already handled in `IDisposable.Dispose`. However, it has no effect if there is no finalizer<br>defined in the object's type, so using it in such cases is just confusing.

This rule raises an issue when `GC.SuppressFinalize` is called for objects of `sealed` types without a finalizer.

Note:\*\* {rule:csharpsquid:S3971} is a stricter version of this rule. Typically it makes sense to activate only one of these 2<br>rules.

## Noncompliant Code Example


    sealed class MyClass
    {
      public void Method()
      {
        ...
        GC.SuppressFinalize(this); //Noncompliant
      }
    }


## Compliant Solution


    sealed class MyClass
    {
      public void Method()
      {
        ...
      }
    }

