
The `HttpOnly` cookie attribute tells the browser to prevent client-side scripts from reading cookies with the attribute, and its use<br>can go a long way to defending against Cross-Site Scripting (XSS) attacks. Thus, as a precaution, the attribute should be set by default on all<br>cookies set server-side, such as session id cookies.

When implementing Cross Site Request Forgery (XSRF) protection, a JavaScript-readable session cookie, generally named XSRF-TOKEN, should be created<br>on the first HTTP GET request. For such a cookie, the `HttpOnly` attribute should be set to "false".

Setting the attribute can be done either programmatically, or globally via configuration files.

## Noncompliant Code Example


    HttpCookie myCookie = new HttpCookie("UserSettings");
    myCookie.HttpOnly = false; // Noncompliant; explicitly set to false
    ...
    Response.Cookies.Add(myCookie);



    HttpCookie myCookie = new HttpCookie("UserSettings"); // Noncompliant; the default value of 'HttpOnly' is used (=false)
    ...
    Response.Cookies.Add(myCookie);


## Compliant Solution


    HttpCookie myCookie = new HttpCookie("UserSettings");
    myCookie.HttpOnly = true; // Compliant
    ...
    Response.Cookies.Add(myCookie);


## See

- [OWASP HttpOnly](https://www.owasp.org/index.php/HttpOnly)
- [OWASP Top 10 2017 Category A7](https://www.owasp.org/index.php/Top_10-2017_A7-Cross-Site_Scripting_%28XSS%29) - Cross-Site Scripting<br>  (XSS)
- [CWE-79](http://cwe.mitre.org/data/definitions/79.html) - Improper Neutralization of Input During Web Page Generation ('Cross-site<br>  Scripting')
- [CWE-1004](https://cwe.mitre.org/data/definitions/1004.html) - Sensitive Cookie Without 'HttpOnly' Flag
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat1) - Insecure Interaction Between Components
- Derived from FindSecBugs rule [HTTPONLY\_COOKIE](https://find-sec-bugs.github.io/bugs.htm#HTTPONLY_COOKIE)

