
When an anonymous type's properties are copied from properties or variables with the same names, it yields cleaner code to omit the new type's<br>property name and the assignment operator.

## Noncompliant Code Example


    var X = 5;
    
    var anon = new
    {
      X = X, //Noncompliant, the new object would have the same property without the "X =" part.
      Y = "my string"
    };


## Compliant Solution


    var X = 5;
    
    var anon = new
    {
      X,
      Y = "my string"
    };

