## Avoid using deprecated SSL/TLS protocol versions by default

### Problematic:


```python
def open_ssl_socket(version=SSL.SSLv2_METHOD):
    pass
```


### Correct:

```python
def open_ssl_socket(version=SSL.TLS_METHOD):
    pass
```

### Rationale:

A deprecated SSL/TLS protocol version is being used as a default value for a method parameter.
It is strongly recommended that use of the following known broken protocol versions be avoided:
* SSL v2
* SSL v3
* TLS v1
* TLS v1.1

[Reference](https://docs.openstack.org/bandit/latest/plugins/b503_ssl_with_bad_defaults.html)