## Pin versions in `apk add`

### Problematic code:

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo
```

### Correct code:

```dockerfile
FROM alpine:3.7
RUN apk --no-cache add foo=1.0
```
### Rationale:

Version pinning forces the build to retrieve a particular version regardless of what’s in the cache. This technique can also reduce failures due to unanticipated changes in required packages.

> https://docs.docker.com/engine/articles/dockerfile_best-practices/