## COPY with more than 2 arguments requires the last argument to end with /

### Problematic code:

```dockerfile
FROM node:carbon
COPY package.json yarn.lock my_app
```

### Correct code:

```dockerfile
FROM node:carbon
COPY package.json yarn.lock my_app/
```
### Rationale:

https://docs.docker.com/engine/reference/builder/#copy

> If multiple <src> resources are specified, either directly or due to the use of a wildcard, then <dest> must be a directory, and it must end with a slash /