## Braces are required for positionals over 9, e.g. ${10}.

### Problematic code:

```sh
echo "Ninth parameter: $9"
echo "Tenth parameter: $10"
```

### Correct code:

```sh
echo "Ninth parameter: $9"
echo "Tenth parameter: ${10}"
```

### Rationale:

For legacy reasons, `$10` is interpreted as the variable `$1` followed by the literal string `0`.

Curly braces are needed to tell the shell that both digits are part of the parameter expansion.

### Exceptions

If you wanted the trailing digits to be literal, `${1}0` will make this clear to both humans and shellcheck.

In `dash`, `$10` is ([wrongly](https://gnu.org/s/autoconf/manual/html_node/Shell-Substitutions.html)) interpreted as `${10}`, so some 'reversed' care should also be taken:

```sh
bash -c 'set a b c d e f g h i j; echo $10 ${1}0' # POSIX: a0 a0
dash -c 'set a b c d e f g h i j; echo $10 ${1}0' # WRONG: j a0
```

### Related resources:

* [BashFaq: How can I access positional parameters after $9?](https://mywiki.wooledge.org/BashFAQ/025)
* [StackOverflow: How to handle more than 10 parameters in shell
](https://stackoverflow.com/questions/4912733/how-to-handle-more-than-10-parameters-in-shell)
* [Autoconf Manual: Shell Substitutions](https://www.gnu.org/savannah-checkouts/gnu/autoconf/manual/html_node/Shell-Substitutions.html) - documents some non-POSIX older shells too

[Source](https://github.com/koalaman/shellcheck/wiki/SC1037)

