## Use #!, not !#, for the shebang.

### Problematic code:

```sh
!#/bin/sh
echo "Hello World"
```

### Correct code:

```sh
#!/bin/sh
echo "Hello World"
```

### Rationale:

The shebang has been accidentally swapped. The `#` should come first: `#!`, not `!#`.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1084)

