## This is a unicode quote. Delete and retype it (or ignore/singlequote for literal).

### Problematic code:

```sh
echo "hello world”
```

### Correct code:

```sh
echo "hello world"
```

### Rationale:

Some software, like OS X, Word and WordPress, may automatically replace your regular quotes with slanted Unicode quotes. The shell does not recognize these quotes and will not respect them.

In this case, you have slanted double quotes in a double quoted string. Try deleting and retyping them, and/or disable “smart quotes” in your editor or OS.

### Exceptions

If you want to use literal slanted double quotes for typographic reasons, you can put them in single quotes to make ShellCheck ignore them:

```sh
printf 'Warning: “wakeonlan” is not installed.\n'
```

You can also just [[ignore]] this warning.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1111)

