## Missing ';' or + terminating -exec. You can't use |/||/&&, and ';' has to be a separate, quoted argument.

### Problematic code:

```sh
find . -type f -exec shellcheck {} | wc -l \;
find . -exec echo {} ;
```

### Correct code:

```sh
find . -type f -exec sh -c 'shellcheck "$1" | wc -l' -- {} \;
find . -exec echo {} \;
```

### Rationale:

`find -exec` is still subject to all normal shell rules, so all shell features like `|`, `||`, `&` and `&&` will apply to the `find` command itself, and not to the command you are trying to construct with `-exec`.

`find . -exec foo {} && bar {} \;` means run the command `find . -exec foo {}`, and if find is successful, run the command `bar "{}" ";"`.

To instead go through each file and run `foo file && bar file` on it, invoke a shell that can interpret `&&`:

```sh
find . -exec sh 'foo "$1" && bar "$1"' -- {} \;
```

You can also use find `-a` instead of shell `&&`:

```sh
find . -exec foo {} \; -a -exec bar {} \;
```

This will have the same effect (`-a` is also the default when two commands are specified, and can therefore be omitted).

### Exceptions

None

[Source](https://github.com/koalaman/shellcheck/wiki/SC2067)

