## Instead of '[ true ]', just use 'true'.

### Problematic code:

```sh
if [ true ]
then
  echo "always triggers"
fi
```

### Correct code:

```sh
if true
then
  echo "always triggers"
fi
```

### Rationale:

This is a stylistic suggestion to use `true` instead of `[ true ]`.

`[ true ]` seems to suggest that the value "true" is somehow relevant to the statement. This is not the case, it doesn't matter. You can replace it with `[ false ]` or `[ wombat ]`, and it will still always be true:

String  | In brackets  | Outside brackets
--------|--------------|-----------------
true    | true         | true
false   | true         | false
wombat  | true         | unknown command

It's therefore better to use it without brackets, so that the "true" actually matters.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2160)

