## SIGKILL/SIGSTOP can not be trapped.

### Problematic code:

```sh
trap 'echo "unkillable"' KILL
```

### Correct code:

Not applicable. This is not possible.

### Rationale:

SIGKILL and SIGSTOP can not be caught/ignored (according to POSIX and as implemented on platforms including Linux and FreeBSD). Trying to trap this signal has undefined results.

### Exceptions:

None. If you come across one, please file an issue about it.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2173)

