## This printf format string has no variables. Other arguments are ignored.

### Problematic code:

```sh
place="world"
printf hello $place
```

### Correct code:

```sh
place="world"
printf "hello %s\n" "$place"
```
### Rationale:

ShellCheck has noticed that you're using a `printf` with multiple arguments, but where the first argument has no `%s` or equivalent variable placeholders.

`echo` accepts zero or more strings to write, e.g. `echo hello world`.

`printf` instead accepts one pattern/template with zero or more `%s`-style placeholders, and one argument for each placeholder.

Rewrite your command using the right semantics, otherwise all arguments after the first one will be ignored:

    $ printf hello world\\n
    hello

    $ printf "hello world\n"
    hello world

    $ printf "hello %s\n" "world"
    hello world

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2182)

