## This default assignment may cause DoS due to globbing. Quote it.

### Problematic code:

```sh
: ${COLUMNS:=80}
```

### Correct code:

```sh
: "${COLUMNS:=80}"
```
### Rationale:

This statement is an idiomatic way of assigning a default value to an environment variable. However, even though it's passed to `:` which ignores arguments, it's better to quote it.

If `COLUMNS='/*/*/*/*/*/*'`, the unquoted, problematic code may spend 30+ minutes trashing the disk as it unnecessarily tries to glob expand the value. 

The correct code uses double quotes to avoid glob expansion, and therefore does not have this problem.

When quoting, make sure to update any inner quotes:

    : ${var:='foo'}    # Assigns foo without quotes
    : "${var:='foo'}"  # Assigns 'foo' with quotes


### Exceptions:

None, though this issue is largely theoretical.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2223)

